package gov.va.genisis2.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.StudyApprovalDTO;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.util.DateUtil;

/**
 * This class is used to convert StudyApprovalDTO to StudyApproval entity and vice-versa.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Component
public class StudyApprovalConverter implements Converter<StudyApproval, StudyApprovalDTO> {

	@Override
	public StudyApprovalDTO convert(StudyApproval studyApproval) {
		StudyApprovalDTO studyApprovalDTO = new StudyApprovalDTO();

		studyApprovalDTO.setId(studyApproval.getId());
		studyApprovalDTO.setProcessId(studyApproval.getProcessId());
		studyApprovalDTO.setObtained(studyApproval.getApprovalIdObtained());
		studyApprovalDTO.setTitle(studyApproval.getTitle());
		studyApprovalDTO.setDescription(studyApproval.getDescription());
		studyApprovalDTO.setCreatedOn(studyApproval.getCreatedOn());
		studyApprovalDTO.setModifiedOn(studyApproval.getModifiedOn());
		studyApprovalDTO.setCreatedBy(studyApproval.getCreatedBy());
		studyApprovalDTO.setModifiedBy(studyApproval.getModifiedBy());

		List<Integer> associatedStudyApprovals = new ArrayList<>();
		if (studyApproval.getAssociatedStudyApproval1() != null) {
			associatedStudyApprovals.add(studyApproval.getAssociatedStudyApproval1());
		}
		
		if (studyApproval.getAssociatedStudyApproval2() != null) {
			associatedStudyApprovals.add(studyApproval.getAssociatedStudyApproval2());
		}
		
		if (studyApproval.getAssociatedStudyApproval3() != null) {
			associatedStudyApprovals.add(studyApproval.getAssociatedStudyApproval3());
		}
		if (!associatedStudyApprovals.isEmpty()) {
			studyApprovalDTO.setAssociatedApprovals(associatedStudyApprovals);
		}

		return studyApprovalDTO;
	}
	
	public List<StudyApprovalDTO> convertStudyApprovals(List<StudyApproval> studyApprovals) {
		List<StudyApprovalDTO> studyApprovalDTOs = null;
		
		if (null != studyApprovals) {
			studyApprovalDTOs = new ArrayList<>();
			for(StudyApproval studyApproval : studyApprovals) {
				studyApprovalDTOs.add(convert(studyApproval));
			}
		}
		
		return studyApprovalDTOs;
	}

	public StudyApproval convert(StudyApprovalDTO studyApprovalDTO) {
		StudyApproval studyApproval = new StudyApproval();

		studyApproval.setId(studyApprovalDTO.getId());
		studyApproval.setProcessId(999999999);
		studyApproval.setApprovalIdObtained(studyApprovalDTO.getObtained());
		studyApproval.setTitle(studyApprovalDTO.getTitle());
		studyApproval.setDescription(studyApprovalDTO.getDescription());
		studyApproval.setCreatedOn(DateUtil.getTodaysDate());
		studyApproval.setModifiedOn(DateUtil.getTodaysDate());
		studyApproval.setCreatedBy(studyApprovalDTO.getCreatedBy());
		studyApproval.setModifiedBy(studyApprovalDTO.getModifiedBy());
		
		List<Integer> associatedApprovalIds = studyApprovalDTO.getAssociatedApprovals();
		if (null != associatedApprovalIds && !associatedApprovalIds.isEmpty()){
			if (null != associatedApprovalIds.get(0)) {
				studyApproval.setAssociatedStudyApproval1(associatedApprovalIds.get(0));
			}
			
			if (null != associatedApprovalIds.get(1)) {
				studyApproval.setAssociatedStudyApproval2(associatedApprovalIds.get(1));
			}
			
			if (null != associatedApprovalIds.get(2)) {
				studyApproval.setAssociatedStudyApproval3(associatedApprovalIds.get(2));
			}
		}

		return studyApproval;
	}
}
